from hummingbird import Hummingbird
from time import sleep

# Replace with your actual serial port
port = "/dev/ttyACM0"

hummingbird = Hummingbird(port)
print(f"Connecting to Hummingbird on {port}...")

# Check initial status
status = hummingbird.status()
print(f"Current Status: {status['state']}")

error = hummingbird.status()['error']
if error is not None:
    # Error is a list of [error_code, error_name, error_description]
    print(f"Error (#{error[0]}): {error[2]}")

# Clear any existing errors
print("Clearing error state...")
hummingbird.clear()

# Turn on
print("Turning laser ON...")
hummingbird.on()
while not hummingbird.is_on():
    if hummingbird.status()['error'] is not None:
        print(f"Error: {hummingbird.status()['error']}")
        break
    sleep(1)

print("Laser is ON. Turning laser OFF in 10 seconds")
sleep(5)
hummingbird.off()
